/* 
 * File:   lcd.h
 * Author: witkatz
 * Proc: 16F
 * Compiler: X8 V1.32
 */

/* Display ON/OFF Control defines */
#define DON         0b00001111  /* Display on      */
#define DOFF        0b00001011  /* Display off     */
#define CURSOR_ON   0b00001111  /* Cursor on       */
#define CURSOR_OFF  0b00001101  /* Cursor off      */
#define BLINK_ON    0b00001111  /* Cursor Blink    */
#define BLINK_OFF   0b00001110  /* Cursor No Blink */

/* Cursor or Display Shift defines */
#define SHIFT_CUR_LEFT    0b00000100  /* Cursor shifts to the left   */
#define SHIFT_CUR_RIGHT   0b00000110  /* Cursor shifts to the right  */
#define SHIFT_DISP_LEFT   0b00000111  /* Display shifts to the left  */
#define SHIFT_DISP_RIGHT  0b00000101  /* Display shifts to the right */

/* Function Set defines */
#define FOUR_BIT   0b00101100  /* 4-bit Interface               */
#define EIGHT_BIT  0b00111100  /* 8-bit Interface               */
#define LINE_5X7   0b00110000  /* 5x7 characters, single line   */
#define LINE_5X10  0b00110100  /* 5x10 characters               */
#define LINES_5X7  0b00111000  /* 5x7 characters, multiple line */

// Pinbelegung LCD
#define DATA_PORT      	PORTB
#define TRIS_DATA_PORT 	TRISB
#define RW_PIN          PORTBbits.RB3           /* PORT for RW */
#define TRIS_RW         TRISBbits.TRISB3    	/* TRIS for RW */
#define RS_PIN          PORTBbits.RB2   	/* PORT for RS */
#define TRIS_RS         TRISBbits.TRISB2    	/* TRIS for RS */
#define E_PIN           PORTBbits.RB0           /* PORT for E  */
#define TRIS_E          TRISBbits.TRISB0    	/* TRIS for E  */

extern void delay1usLCD(void);
extern void delay5msLCD(void);
extern void delay45msLCD(void);

void InitLCD(uint8_t);
void WriteCmdLCD(uint8_t);
int8_t BusyLCD(void);
void SetDDRamAddrLCD(uint8_t);
void ClearLCD(void);
void WriteCharLCD(char);
void WriteStringLCD(const char *);
void WriteHexLCD(uint8_t);
